function [result, G_fault, B_fault] = perform_opf(mpc_fault, fault_type, fault_id, R, X)
%PERFORM_OPF 运行最优潮流并返回结果
%   [result, G_fault, B_fault] = PERFORM_OPF(mpc_fault, fault_type, fault_id, R, X)
%   返回OPF求解结果，以及故障情况下的电导和电纳。

    % 获取支路数据
    branches_fault = mpc_fault.branch;
    
    % 计算电导（G）和电纳（B）
    G_fault = R ./ (R.^2 + X.^2);
    B_fault = -X ./ (R.^2 + X.^2);
    
    % 如果是线路故障，断开的线路电导和电纳置为0
    if strcmp(fault_type, 'Line')
        G_fault(fault_id) = 0;
        B_fault(fault_id) = 0;
    end
    
    % % 禁用输出，防止runopf打印结果
    % opf_options = mpoption('verbose', 0);  % 设置不显示详细信息
    % [result, ~] = runopf(mpc_fault, opf_options);  % 运行OPF并应用设置
    % 
    % % 只返回求解结果和状态
    % if result.success
    %     fprintf('OPF求解成功！\n');
    % else
    %     fprintf('OPF求解失败！\n');
    % end

    % 运行OPF
    result = runopf(mpc_fault);


end
